IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_BancoGalicia_Proveedores_OP_OPG_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_BancoGalicia_Proveedores_OP_OPG_TX
END
GO


CREATE FUNCTION [dbo].[CF_BancoGalicia_Proveedores_OP_OPG_TX](@pId_Trans INT, @pId_Valor INT, @pNroSecuencia INT) 
RETURNS CHAR(271)
AS
BEGIN

/*================================================================================================================================*/

/*Variables del Archivo*/
DECLARE @Retorno						CHAR(58)

/*--------------------------------------------------------------------------------------------------------------------------------*/

DECLARE @aCBU					CHAR(22)	-- NRO: 01. NOMBRE: CBU/CVU/ALIAS/NRO CUENTA.	TIPO: A. TAM: 022. POS. INI: 001. POS_FIN: 022. OBSERVACION: CBU/CVU/ALIAS/NRO CUENTA
DECLARE @aIMP_PAGO				CHAR(14)	-- NRO: 02. NOMBRE: IMP_PAGO.					TIPO: D. TAM: 014. POS. INI: 023. POS_FIN: 037. OBSERVACION: Importe del Pago.
DECLARE @aMotivo				CHAR(10)	-- NRO: 03. NOMBRE: MOTIVO.						TIPO: A. TAM: 010. POS. INI: 038. POS_FIN: 048. OBSERVACION: Motivo obligatorio.
DECLARE @aDescripcion			CHAR(12)	-- NRO: 04. NOMBRE: DESCRIPCION.				TIPO: A. TAM: 012. POS. INI: 049. POS_FIN: 061. OBSERVACION: Descripcion del Pago.

/*FIN Variables del Archivo*/

/*================================================================================================================================*/

/*Variables de Calculo intermedio*/
DECLARE @Importe					DECIMAL(12,2)
DECLARE @Id_Proveedor				INT
DECLARE @Cuit						VARCHAR(19)
DECLARE @Cbu						VARCHAR(22)
DECLARE @Descrip_Cbte				VARCHAR(12)
/*FIN Variables de Calculo intermedio*/


/*Asignacion de variables*/
SELECT
@Importe			= ISNULL(Importe, 0)
FROM Valores
WHERE
Id_Trans = @pId_Trans
AND Id_Valor = @pId_Valor

SELECT
@Id_Proveedor	= ISNULL(Id_Proveedor, 0),
@Descrip_Cbte   = RTRIM(LTRIM(ISNULL(Id_Tipo_Cbte, ''))) + ' ' +  CONVERT(VARCHAR(8),RTRIM(LTRIM(ISNULL(Comprobante_Nro, ''))))
FROM Cbtes
WHERE
Id_Trans = @pId_Trans

SELECT
@Cuit			= LTRIM(RTRIM(ISNULL(Cuit, ''))),
@Cbu			= LTRIM(RTRIM(ISNULL(CBU, '')))
FROM Proveedores
WHERE
Id_Proveedor = @Id_Proveedor
/*FIN Asignacion de variables*/

/*================================================================================================================================*/

SET @aCBU			=	@Cbu

SET @aIMP_PAGO		=	CAST(CAST(ISNULL(@Importe, 0) AS DECIMAL(12, 2)) AS VARCHAR)

/*
Motivos:
varios, alquiler, cuota, expensas
*/

SET @aMotivo		= 'varios'	

SET @aDescripcion	= @Descrip_Cbte

/*================================================================================================================================*/

SET @Retorno =	@aCBU						+ ';' +
				@aIMP_PAGO					+ ';' +
				@aMotivo					+ ';' +
				@aDescripcion				

/*================================================================================================================================*/
					
RETURN @Retorno
END
